IF NOT OBJECT_ID('TRG_EST_ALCADA_CP_PED_ALCADAS_LIB') IS NULL
	BEGIN 
		DROP TRIGGER TRG_EST_ALCADA_CP_PED_ALCADAS_LIB
	END
	
GO	

CREATE TRIGGER TRG_EST_ALCADA_CP_PED_ALCADAS_LIB ON EST_ALCADA_CP_PED_ALCADAS_LIB FOR INSERT
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Liberação de pedido de maior alçada
'Tabelas.............: 
'Dt Modificação......: 07/01/2021
'Modificação.........: Voltando versão do script anterior, que não vinculava com GLB_USU_GRP
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/

AS
	BEGIN 		
		DECLARE @RS_ALCADA TABLE (CD_CTR		INT, 
								  CD_GRP_USU	INT, 
								  PERC_ALCADA	MONEY)
		
		
		--VERIFICANDO A MAIOR ALCADA DE LIBERACAO PARA O PEDIDO						  
		INSERT INTO @RS_ALCADA (CD_CTR, CD_GRP_USU, PERC_ALCADA)
			SELECT TOP 1 
					EST_ALCADA_CP_PED_ALCADAS.CD_CTR, 
					EST_ALCADA_CP_PED_ALCADAS.CD_GRP_USU,
					EST_ALCADA_CP_GLB_GRP_USU.PERC_ALCADA  
			  FROM EST_ALCADA_CP_PED_ALCADAS 
				   INNER JOIN EST_ALCADA_CP_GLB_GRP_USU ON  EST_ALCADA_CP_PED_ALCADAS.CD_GRP_USU = EST_ALCADA_CP_GLB_GRP_USU.CD_GRP 
				   INNER JOIN INSERTED I ON EST_ALCADA_CP_PED_ALCADAS.CD_CTR = I.CD_CTR 		
			  ORDER BY EST_ALCADA_CP_GLB_GRP_USU.PERC_ALCADA DESC
			  
		
		--VERIFICANDO SE A LIBERACAO CORRENTE E A MAIS ALTA PARA O PEDIDO. SE FOR A MAIL ALTA LIBERA O PEDIDO	
		INSERT INTO EST_ALCADA_CP_PED_LIB 
			SELECT DISTINCT 
					I.CD_CTR,
					I.CD_IT 
			FROM INSERTED I
				 INNER JOIN EST_ALCADA_CP_PED_ALCADAS ON I.CD_CTR = EST_ALCADA_CP_PED_ALCADAS.CD_CTR 
													 AND I.CD_IT = EST_ALCADA_CP_PED_ALCADAS.CD_IT
				 INNER JOIN @RS_ALCADA RS_ALCADA ON EST_ALCADA_CP_PED_ALCADAS.CD_CTR			= RS_ALCADA.CD_CTR 
											    AND EST_ALCADA_CP_PED_ALCADAS.CD_GRP_USU	= RS_ALCADA.CD_GRP_USU				
							
	END
	

GO

ALTER TABLE [DBO].[EST_ALCADA_CP_PED_ALCADAS_LIB] ENABLE TRIGGER [TRG_EST_ALCADA_CP_PED_ALCADAS_LIB]
GO